%------------------------------------------------------------------------------
% File     : NUM832^5 : TPTP v7.4.0. Bugfixed v5.2.0.
% Domain   : Number Theory (Induction on naturals)
% Problem  : TPS problem from PETER-THMS
% Version  : Especial.
% English  :

% Refs     : [Bro09] Brown (2009), Email to Geoff Sutcliffe
% Source   : [Bro09]
% Names    : tps_0998 [Bro09]

% Status   : Unknown
% Rating   : 1.00 v5.2.0
% Syntax   : Number of formulae    :    6 (   0 unit;   4 type;   1 defn)
%            Number of atoms       :   46 (   1 equality;  25 variable)
%            Maximal formula depth :   15 (   6 average)
%            Number of connectives :   42 (   0   ~;   0   |;   4   &;  32   @)
%                                         (   0 <=>;   6  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :    5 (   5   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    6 (   4   :;   0   =)
%            Number of variables   :   13 (   0 sgn;  12   !;   1   ?;   0   ^)
%                                         (  13   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_UNK_EQU_NAR

% Comments : This problem is from the TPS library. Copyright (c) 2009 The TPS
%            project in the Department of Mathematical Sciences at Carnegie
%            Mellon University. Distributed under the Creative Commons copyleft
%            license: http://creativecommons.org/licenses/by-sa/3.0/
%          : 
% Bugfixes : v5.2.0 - Added missing type declarations.
%------------------------------------------------------------------------------
thf(c0_type,type,(
    c0: $i )).

thf(cR_type,type,(
    cR: $i > $i > $i > $o )).

thf(cS_type,type,(
    cS: $i > $i )).

thf(cIND_type,type,(
    cIND: $o )).

thf(cIND_def,definition,
    ( cIND
    = ( ! [Xp: $i > $o] :
          ( ( ( Xp @ c0 )
            & ! [Xx: $i] :
                ( ( Xp @ Xx )
               => ( Xp @ ( cS @ Xx ) ) ) )
         => ! [Xx: $i] :
              ( Xp @ Xx ) ) ) )).

thf(cTHM604,conjecture,
    ( ( cIND
      & ! [Xn: $i] :
          ( cR @ c0 @ Xn @ ( cS @ Xn ) )
      & ! [Xm: $i,Xk: $i] :
          ( ( cR @ Xm @ ( cS @ c0 ) @ Xk )
         => ( cR @ ( cS @ Xm ) @ c0 @ Xk ) )
      & ! [Xm: $i,Xn: $i,Xk: $i,Xl: $i] :
          ( ( cR @ ( cS @ Xm ) @ Xn @ Xl )
         => ( ( cR @ Xm @ Xl @ Xk )
           => ( cR @ ( cS @ Xm ) @ ( cS @ Xn ) @ Xk ) ) ) )
   => ! [Xx: $i,Xy: $i] :
      ? [Xz: $i] :
        ( cR @ Xx @ Xy @ Xz ) )).

%------------------------------------------------------------------------------
